package Beans;

import java.rmi.RemoteException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.ejb.DuplicateKeyException;
import javax.ejb.CreateException;

public class CalcBean implements SessionBean { 
  BonusHome homebonus;

  public Bonus calcBonus(int multiplier, double bonus, String socsec)
			throws RemoteException, DuplicateKeyException, CreateException {

    Bonus theBonus = null;
    double calc = (multiplier*bonus);

    try {
      InitialContext ctx = new InitialContext();
      Object objref = ctx.lookup("bonus");
      homebonus = (BonusHome)PortableRemoteObject.narrow(objref, BonusHome.class);
    } catch (Exception NamingException) {
      NamingException.printStackTrace();
    }

//Store data in entity Bean
    try {
      theBonus = homebonus.create(calc, socsec);
    } catch (java.rmi.RemoteException e) {
      String message = e.getMessage();
      e.printStackTrace();
    }
    return theBonus;
  }

  public Bonus getRecord(String socsec) {
    Bonus record=null;
//Use primary key to retrieve data from entity Bean
    try {
      record = homebonus.findByPrimaryKey(socsec);
    } catch (java.rmi.RemoteException e) {
      String message = e.getMessage();
    } catch (javax.ejb.FinderException e) {
      e.printStackTrace();
    }
    return record;
  }
  public void ejbCreate() { }
  public void setSessionContext(SessionContext context) { }
  public void ejbRemove() { }
  public void ejbActivate() { }
  public void ejbPassivate() { }
  public void ejbLoad() { }
  public void ejbStore() { }
}

