import javax.naming.*; 
import javax.rmi.PortableRemoteObject;
import Beans.*;

public class JBonusBean {

  private String strMult, socsec, message; 
  private double bonusAmt; 
  CalcHome homecalc;

  public JBonusBean(){
    try{
      InitialContext ctx = new InitialContext();
      Object objref = ctx.lookup("calcs");
      homecalc = (CalcHome)PortableRemoteObject.narrow(objref, CalcHome.class);
    } catch (javax.naming.NamingException e) {
      e.printStackTrace();
    }
  }

  public double getBonusAmt() {
    if(strMult != null){
      Integer integerMult = new Integer(strMult);
      int multiplier = integerMult.intValue();
      try {
        double bonus = 100.00;
        Calc theCalculation = homecalc.create();
        Bonus theBonus = theCalculation.calcBonus(multiplier, bonus, socsec);
        Bonus record = theCalculation.getRecord(socsec);
        bonusAmt = record.getBonus();
        socsec = record.getSocSec();
      } catch (javax.ejb.DuplicateKeyException e) {
        message = e.getMessage();
      } catch (javax.ejb.CreateException e) {
        e.printStackTrace();
      } catch (java.rmi.RemoteException e) {
        e.printStackTrace();
      }
      return this.bonusAmt;
    } else {
      this.bonusAmt = 0;
      this.message = "None.";
      return this.bonusAmt;
    }
  }
 
  public String getMessage(){
    return this.message; 
  }

  public String getSocsec(){
    return this.socsec;
  }

  public String getStrMult(){
    return this.strMult;
  }
 
  public void setSocsec(String socsec) {
   this.socsec = socsec;
  }

  public void setStrMult(String strMult) {
   this.strMult = strMult;
  }
}
