//Bean managed entity bean

package Beans;

import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Connection;
import java.sql.ResultSet;

public class BonusBean implements EntityBean {
  private EntityContext context;
  private Connection con;
  private String dbName = "java:comp/env/jdbc/BonusDB";
  private InitialContext ic = null;
  private PreparedStatement ps = null;
  private double bonus;
  private String socsec;

  public double getBonus() { 
    System.out.println("getBonus");
    return this.bonus; 
  }
  public String getSocSec() {
    System.out.println("getSocSec");
    return this.socsec;
  }

  public String ejbCreate(double bonus, String socsec) 
		throws RemoteException, CreateException, SQLException {

    System.out.println("Create");

//After creating a row for the database, the
//ejbStore method saves the data to the database.
    this.socsec=socsec;
    this.bonus=bonus;
    try {
      ic = new InitialContext();
      DataSource ds = (DataSource) ic.lookup(dbName);
      con = ds.getConnection();
      ps = con.prepareStatement("INSERT INTO BONUS VALUES (? , ?)");
      ps.setString(1, socsec);
      ps.setDouble(2, bonus);
      ps.executeUpdate();
    } catch (javax.naming.NamingException ex) {
      ex.printStackTrace();
    } finally {
      ps.close();
      con.close();
    }
    return socsec;
  }

  public void ejbPostCreate(double bonus, String socsec) 
		throws RemoteException, CreateException, SQLException {

//This method takes the same arguments as the create method.
//The container calls it after ejbCreate() completes.
//Use this method for any special processing needed after
//the bean is created, but before it becomes available
//to the client. Leave empty if no special processing
//is needed.

    System.out.println("Post Create");

  }

//The finder implementation returns the primary key type,
//but the home method returns the ejb type

  public String ejbFindByPrimaryKey(String primaryKey)
			throws RemoteException, FinderException, SQLException {

//This method locates the row in the table using the
//social security number, and the ejbLoad method loads
//the data into a Bean
    String key=null;

    System.out.println("Find by primary key");

    try {
      ic = new InitialContext();
      DataSource ds = (DataSource) ic.lookup(dbName);
      con = ds.getConnection();
      ps = con.prepareStatement("SELECT socsec FROM BONUS WHERE socsec = ? ");
      ps.setString(1, primaryKey);
      ResultSet rs = ps.executeQuery();
      if(rs.next()) {
        key = primaryKey;
      } else {
        System.out.println("Find Error");
      }
    } catch (javax.naming.NamingException ex) {
      ex.printStackTrace();
    } finally {
      ps.close();
      con.close();
    }
    return key;
  }

  public void ejbLoad() {

//Load data from database

    System.out.println("Load method");

    try {
      ic = new InitialContext();
      DataSource ds = (DataSource) ic.lookup(dbName);
      con = ds.getConnection();
      ps = con.prepareStatement("SELECT * FROM BONUS WHERE SOCSEC = ?");
      ps.setString(1, this.socsec);
      ResultSet rs = ps.executeQuery();
      if(rs.next()){
        this.bonus = rs.getDouble(2);
      } else {
        System.out.println("Load Error");
      }
    } catch (java.sql.SQLException ex) {
      ex.printStackTrace();
    } catch (javax.naming.NamingException ex) {
      ex.printStackTrace();
    } finally {
      try {
        ps.close();
        con.close();
      } catch (java.sql.SQLException ex) {
        ex.printStackTrace();
      }
    }
  }

  public void ejbStore() { 

//Store data to database after Bean created

    System.out.println("Store method");

    try {
      DataSource ds = (DataSource)ic.lookup(dbName);
      con = ds.getConnection();
      ps = con.prepareStatement("UPDATE BONUS SET BONUS = ? WHERE SOCSEC = ?");
      ps.setDouble(1, bonus);
      ps.setString(2, socsec);
      int rowCount = ps.executeUpdate();
    } catch (javax.naming.NamingException ex) {
      ex.printStackTrace();
    } catch (java.sql.SQLException ex) {
      ex.printStackTrace();
    } finally {
      try {
        ps.close();
        con.close();
      } catch (java.sql.SQLException ex) {
        ex.printStackTrace();
      }
    }
  }

  public void ejbRemove() throws RemoteException {

    System.out.println("Remove method");

    try {
      DataSource ds = (DataSource)ic.lookup(dbName);
      con = ds.getConnection();
      ps = con.prepareStatement("DELETE FROM BONUS WHERE SOCSEC = ?");
      ps.setString(1, socsec);
      ps.executeUpdate();
    } catch (java.sql.SQLException ex) {
      ex.printStackTrace();
    } catch (Exception ex) {
      ex.printStackTrace();
    } finally {
      try {
        ps.close();
        con.close();
      } catch (java.sql.SQLException ex) {
        ex.printStackTrace();
      }
    }
  }

  public void ejbActivate() {

//When a bean is activated, the container calls its
//ejbLoad method.

    System.out.println("Activate method");
    socsec = (String)context.getPrimaryKey();
  }

  public void ejbPassivate() { 
//When a bean is passivated, the container calls its
//ejbStore method.

    System.out.println("Passivate method");

     socsec = null;
  }

  public void setEntityContext(javax.ejb.EntityContext ctx){
    System.out.println("setEntityContext method");
    this.context = context;
  }

  public void unsetEntityContext(){
    System.out.println("unsetEntityContext method");

     context = null;
  }
}
