import javax.naming.*; 
import javax.rmi.PortableRemoteObject;
import Beans.*;

import java.io.StringWriter;
import java.io.IOException;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;

public class JBonusBean {

  private String strMult, socsec, message; 
  private double bonusAmt; 
  CalcHome homecalc;
  Calc theCalculation;

  public JBonusBean(){
    try{
      InitialContext ctx = new InitialContext();
      Object objref = ctx.lookup("calcs");
      homecalc = (CalcHome)PortableRemoteObject.narrow(objref, CalcHome.class);
    } catch (javax.naming.NamingException e) {
      e.printStackTrace();
    }
  }

  public double getBonusAmt() {
    if(strMult != null){
      Integer integerMult = new Integer(strMult);
      int multiplier = integerMult.intValue();
      Bonus theBonus=null, record=null;
      try {
        double bonus = 100.00;
        theCalculation = homecalc.create();
        theBonus = theCalculation.calcBonus(multiplier, bonus, socsec);
        record = theCalculation.getRecord(socsec);
        bonusAmt = record.getBonus();
        socsec = record.getSocSec();
      } catch (java.sql.SQLException e) {
        this.bonusAmt = 0.0;
        this.socsec = "000";
        this.message = e.getMessage();
      } catch (javax.ejb.CreateException e) {
        this.bonusAmt = 0.0;
        this.socsec = "000";
        this.message = e.getMessage();
      } catch (java.rmi.RemoteException e) {
        this.bonusAmt = 0.0;
        this.socsec = "000";
        this.message = e.getMessage();
      }
      genXML();
      return this.bonusAmt;
    } else {
      this.bonusAmt = 0;
      this.message = "None.";
      return this.bonusAmt;
    }
  }

  private void genXML(){
    Bonus records = null;
    XmlDocument doc = new XmlDocument();
    ElementNode root = (ElementNode)doc.createElement("report");
    doc.appendChild(root);
    try{
    //Get database record 
      records = theCalculation.getRecord(socsec);
    //Retrieve the social security number from record
       String ssRetrieved = records.getSocSec();
    //Retrieve bonus amount from record
       double bRetrieved = records.getBonus();
    //Convert double to string
       Double bonusObj = new Double(bRetrieved);
       String bString = bonusObj.toString();
    //Create child node
       ElementNode bonusCalc = (ElementNode)doc.createElement("bonusCalc");
    //Add attributes to child node
       bonusCalc.setAttribute("ssnum", ssRetrieved);
       bonusCalc.setAttribute("bonusAmt", bString);
    //Add child node to root
      root.appendChild(bonusCalc);
    } catch (java.rmi.RemoteException e) {
      e.printStackTrace();
    }

    try{
      StringWriter out = new StringWriter(); 
      doc.write(out);
      System.out.println(out);
    } catch (java.io.FileNotFoundException fe) {
      System.out.println("Cannot write XML");
    } catch (IOException ioe) {
      System.out.println("cannot write XML");
    }
  }
 
  public String getMessage(){
    return this.message; 
  }

  public String getSocsec(){
    return this.socsec;
  }

  public String getStrMult(){
    return this.strMult;
  }
 
  public void setSocsec(String socsec) {
   this.socsec = socsec;
  }

  public void setStrMult(String strMult) {
   this.strMult = strMult;
  }
}
